# A minimum of Robot Framework 2.9.1 is required
# This Test Suite has been tested with Robot Framework 3.0

# Copyright 2017 Juniper Networks, Inc. All rights reserved.
# Licensed under the Juniper Networks Script Software License (the "License").
# You may not use this script file except in compliance with the License, which is located at
# http://www.juniper.net/support/legal/scriptlicense/
# Unless required by applicable law or otherwise agreed to in writing by the parties, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# Author: gonzalo@juniper.net


*** Settings ***
Documentation     Smoke Test cases
Resource	${EXECDIR}/resource_files/northstar_resources.txt
Library		OperatingSystem
Library		Collections
Library		String

*** Variables ***

${path}=	${CURDIR}

*** Test Cases ***

Test 1.0 Initial Verification
	[Documentation] 	As very first test execution step, validate initial authentication and topology index in Northstar
	[Tags] 	bringup 	northstar 	get
	[Setup] 	Authenticate Northstar
	Then Get Topology Index from Northstar

Test 1.2 Search Nodes using RouterIds
	[Documentation] 	Get specific node using RouterId from Northstar using the router id
	[Tags] 	node 	northstar 	get
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Search Nodes using RouterIds from Northstar

Test 1.3 Search Nodes using Hostnames
	[Documentation] 	Get specific node using hostname from Northstar using the check_hostname key in the input yaml test file
	[Tags] 	node 	northstar 	get
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Get Nodes using Hostnames from Northstar

Test 1.4 Search Nodes using internal Names
	[Documentation] 	Get specific node using internal names from Northstar as test
	[Tags] 	node 	northstar 	get
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Get Nodes using Names from Northstar

Test 1.5 Search Links using Hostnames
	[Documentation] 	Get specific links using endpoint hostnames from Northstar, extracted from the check_link key in the input yaml test file
	[Tags] 	link 	northstar 	get
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Search Links using Hostnames from Northstar

Test 1.6 Update Links using Hostnames
	[Documentation] 	Update specific links using endpoint hostnames from Northstar, extracted out of the update_link key in the input yaml test file
	[Tags] 	update-link 	northstar 	update
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Update Links using Hostnames from Northstar

Test 1.6 Update Nodes using RouterIds
	[Documentation] 	Update specific nodes using endpoint router Ids from Northstar, extracted out of the update_node key in the input yaml test file
	[Tags] 	update-node 	northstar 	update 	routerid
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Update Nodes using RouterIds from Northstar

Test 1.7 Update Nodes using Hostnames
	[Documentation] 	Update specific nodes using endpoint hostnames from Northstar, extracted out of the update_node key in the input yaml test file
	[Tags] 	northstar 	update 	hostname
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Update Nodes using Hostnames from Northstar

Test 1.8 Create LSPs using source, destination and name
	[Documentation] 	Create LSPs using source and destination IPv4 addresses and name regexp matching local LSP template regexp, extracted out of the create_lsp key in the input yaml test file
	[Tags] 	create-lsp 	northstar 	create
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Create LSPs using Endpoints in Northstar

Test 1.9 Create LSP Automesh using list of routers and prefix
	[Documentation] 	Create LSP Automesh among routers using list of IPv4 addresses and name regexp matching local LSP template regexp, extracted out of the create_lsp key in the input yaml test file
	[Tags] 	create-automesh 	northstar 	create 	static-list
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Create Automesh using Endpoints in Northstar

Test 1.10 Create LSP Automesh using PCEP enabled routers
	[Documentation] 	Create LSP Automesh among PCEP active routers and name regexp matching local LSP template regexp, extracted out of the create_lsp key in the input yaml test file
	[Tags] 	create-automesh-pcep 	northstar 	create 	PCEP
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Create Automesh using PCEP routers from Northstar

Test 1.11 Create Nodes using names
	[Documentation] 	Create planned nodes in the topology using Hostname
	[Tags] 	create-node 	northstar 	create
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Create Nodes using Hostnames in Northstar

Test 1.12 Get LSP using source and name
	[Documentation] 	Obtain and read LSP based on its name and IPv4 address for the source
	[Tags] 	get-lsp 	northstar 	read
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Get LSP using Source and Name in Northstar

Test 1.13 Update LSP using source and name
	[Documentation] 	Update specific LSP based on its name and IPv4 address for the source router
	[Tags] 	update-lsp 	northstar 	read
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Update LSP using Source and Name in Northstar

Test 1.14 Delete LSP using source and name
	[Documentation] 	Delete specific LSP based on its name and IPv4 address for the source router
	[Tags] 	delete-lsp 	northstar 	delete
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Delete LSP using Source and Name in Northstar

Test 1.15 Reset Topology
	[Documentation] 	Global reset on the planned topology details
	[Tags] 	reset-topo 	northstar 	delete
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Reset Topology in Northstar

Test 1.16 Reset LSPs and Topology
	[Documentation] 	Global reset on the planned topology details and removal of all PCE initiated LSPs
	[Tags] 	reset-lsps-topo 	northstar 	delete 	lsp
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	Then Delete All LSPs from Northstar
	And Reset Topology in Northstar

Test 2.1 Shortest Delay computations
	[Documentation] 	Combined used case in Northstar updating link delay information first, then creating delay SPF specific LSPs
	[Tags] 	shortest-delay 	combined 	northstar 	link 	lsp
	[Setup] 	Authenticate Northstar
	When Get Topology Index from Northstar
	And Update Links using Hostnames from Northstar
	Then Create LSPs using Endpoints in Northstar
