<!--<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "../../../../../../../../../www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:glossary="com.organic.common.util.Glossary"   exclude-result-prefixes="xsl glossary">

<xsl:output method="xhtml" omit-xml-declaration="yes" encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"/>
<xsl:param name="locale"><xsl:choose><xsl:when test="content/meta/locale != ''"><xsl:value-of select="content/meta/locale"/></xsl:when><xsl:otherwise>en_US</xsl:otherwise></xsl:choose></xsl:param>
<xsl:template match="/content">
    
<html>

<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<link rel="stylesheet" href="../../../../../../../../assets/css/global.css" type="text/css" media="all" charset="utf-8" />
	<link rel="stylesheet" href="../../../../../../../../assets/css/print.css" type="text/css" media="print" charset="utf-8" />    
	<title><xsl:value-of select="meta/title"/></title>	

</head>
 <body>


<img src="../../../../../../../../shared/img/header/logo-top-m.gif" alt="Juniper Networks" class="printLogo"/>

 
 <xsl:element name="div">
 <xsl:attribute name="id">print_link</xsl:attribute>
	<xsl:element name="a">
	  <xsl:attribute name="href">javascript:window.print()</xsl:attribute>
	  <xsl:attribute name="title"><xsl:value-of select="glossary:getString('print-icon.print', $locale)"/></xsl:attribute>
	  <div class="printCompTbl">&#160;</div>	  
	</xsl:element>
 </xsl:element>
 
        <xsl:apply-templates select="products" mode="pivot" />
 </body>
</html>
    </xsl:template>

    

 <xsl:template match="products" mode="pivot">
 <xsl:variable name="products" select="/content/products"/>

<div xmlns="http://www.w3.org/1999/xhtml" id="TB_compTbl_module">
 <table  xmlns="http://www.w3.org/1999/xhtml" cellpadding="0" cellspacing="0" id="TB_compTbl" border="0" class="prodCompTbl" style="display:table;position:relative;">
     <thead>
                <tr>
                    <th width="100"><img src="../../../../../../../../shared/img/global/blank.gif" width="100" height="1"/></th>
                    <xsl:for-each select="product">
                        <th width="110"  style="padding:8px 15px;"><xsl:value-of select="title"/>
                         <br/><img src="../../../../../../../../shared/img/global/blank.gif" width="110" height="1"/>
                         </th>
                    </xsl:for-each>
                </tr>
    </thead>
    <tbody>
         
         
                <xsl:for-each select="$products/product[1]/content/fields/field">
                  <xsl:if test="not(./name = '')">    
                    <xsl:variable name="f" select="position()"/>                  
                    <tr>
                        <td class="hd" width="110" style="padding:8px;" valign="top"><xsl:value-of select="$products/product[1]/content/fields/field[$f]/name"/></td>
                        <xsl:for-each select="$products/product">

                            <td style="padding:8px 10px;" valign="top"><xsl:copy-of select="content/fields/field[$f]/content/node()" />
                            </td>
                        </xsl:for-each>
                    </tr>
                    </xsl:if>
                </xsl:for-each>
    </tbody>
 </table>
 </div>
</xsl:template>

   
</xsl:stylesheet>
