/*
 * Baynote Observer for www.juniper.net
 * Last updated: 01/28/09
 */
function bn_isNotEmpty(name) {
	return (name != null) && (name != "");
}
function bn_getOrderInfo() {
	if (typeof(bnOrderId) != "undefined" && bn_isNotEmpty(bnOrderId))
		baynote_tag.attrs.purchaseId = bnOrderId;
	if (typeof(bnOrderTotal) != "undefined" && bn_isNotEmpty(bnOrderTotal))
		baynote_tag.attrs.totalPurchases = parseFloat(bnOrderTotal);
	if (typeof(bnOrderDetails) != "undefined" && bn_isNotEmpty(bnOrderDetails))
		baynote_tag.attrs.purchaseDetails = bnOrderDetails;
}
function bn_showObserver() {
	/* 1. set customer id */
	bn_customerId = "juniper";
	/* 2. set customer code */
	bn_code = "www";
	var bn_locHref = window.location.href;
	if (bn_locHref.indexOf("https:///") == 0) {
		baynote_tag.server = "https:///" + bn_customerId + "-" + bn_code + ".baynote.net";
	} else {
		baynote_tag.server = "http://" + bn_customerId + "-" + bn_code + ".baynote.net";
	}
	baynote_tag.customerId = bn_customerId;
	baynote_tag.code = bn_code;
	baynote_tag.type = "baynoteObserver";
	/* 3. set customer domain (optional) */
	if (bn_locHref.indexOf("juniper.net") > 0) {
		baynote_globals.cookieDomain = "juniper.net";
	}
	/* 4. collect purchase info (optional) */ 
	/* bn_getOrderInfo(); */
	
	/* 5. set custom attributes */
	/* Example:
	 * baynote_tag.docAttrs.date = "2009-01-01";
	 * baynote_tag.docAttrs.fileSize = getFileSize();
	 */
	baynote_tag.show();
}
if (typeof(baynote_tag)!="undefined") {
	bn_showObserver();
}

