/**
 * $Id: cookie.js $
 * simple user management script
 * Copyright (c) 2003 Brandon Blackmoor
 * Brandon Blackmoor (bblackmoor@sourceforge.net)
 */

function createCookie(name, value, days)
{
    if (days)
    {
        var date = new Date();
        date.setTime(date.getTime() + (days*24*60*60*1000));
        var expires = "; expires=" + date.toGMTString();
    }
    else expires = "";
    document.cookie = name + "=" + value + expires + "; path=/";
}

function readCookie(name)
{
    var nameEquals = name + "=";
    var ca = document.cookie.split(';');
    for (var i=0; i < ca.length; i++)
    {
        var c = ca[i];
        while (c.charAt(0)==' ') c = c.substring(1, c.length);
        if (c.indexOf(nameEquals) == 0)
        {
            return c.substring(nameEquals.length, c.length);
        }
    }
    return null;
}

function deletePageCookie(name, path)
{
    var value = readCookie(name);
    if (value != null)
    {
        document.cookie = name + "=" + "; path=" + getPath() + "; expires=Thu, 01-Jan-70 00:00:01 GMT";
    }
    return value;
}

function getFilename()
{
    var href = window.location.href;
    var file = href.substring(href.lastIndexOf("/") + 1);
    return file;
}

function getPath()
{
    var href = window.location.href;
    var path = href.substring(href.indexOf("//") + 2);
    path = path.substring(path.indexOf("/"));
    path = path.substring(0, path.lastIndexOf("/") + 1);
    return path;
}
