/* This Javascript is used for rignav functions in Techpubs pages. */

var productIndex = 	[[['cseries'],['&qptechpubsnew=subject%3AC2000%2Csubject%3AC4000%2Curl%3A%2Ftechpubs%2Fhardware%2Fc-series%2F']],
			[['eseries'],['&qptechpubsnew=url%3A%2Ftechpubs%2Fhardware%2Ferx%2F']],
			[['exseries'],['&qptechpubsnew=subject%3Aexseries']],
			[['jseries'],['&qptechpubsnew=url%3A%2Ftechpubs%2Fsoftware%2Fjseries%2F%2Curl%3A%2Ftechpubs%2Fsoftware%2Fjunos-security%2F%2Curl%3A%2Ftechpubs%2Fsoftware%2Fjunos-jseries%2F%2Curl%3A%2Ftechpubs%2Fhardware%2Fjunos-jseries%2F']],
			[['jcs1200'],['&qptechpubsnew=url%3A%2Ftechpubs%2Fhardware%2Fjcs-1200%2F%2Csubject%3Ajcs1200']],
			[['mseries'],['&qptechpubsnew=url%3A%2Ftechpubs%2Fhardware%2Fm-series%2F%2Curl%3A%2Ftechpubs%2Fhardware%2Fcommon%2F%2Curl%3A%2Ftechpubs%2Fen_US%2Frelease-independent%2Fjunos%2Finformation-products%2Ftopic-collections%2Fhardware%2Fm-series%2F%2Curl%3A%2Ftechpubs%2Fqrc%2F%2Csubject%3Amseries']],
			[['mxseries'],['&selectedprod=selectedprod&qptechpubsnew=url%3A%2Ftechpubs%2Fhardware%2Fcommon%2F%2Csubject%3Amxseries']],
			[['netscreenseries'],['&qptechpubsnew=url%3A%2Ftechpubs%2Fhardware%2Fnetscreen-appliances%2F%2Curl%3A%2Ftechpubs%2Fhardware%2Fnetscreen-systems%2F%2Curl%3A%2Ftechpubs%2Fhardware%2Fnetscreen-certifications%2F%2Curl%3A%2Ftechpubs%2Fhardware%2Fpim_guide%2F']],
			[['srx5000'],['&qptechpubsnew=url%3A%2Ftechpubs%2Fhardware%2Fjunos-srx%2Fsrx5000%2F%2Curl%3A%2Ftechpubs%2Fsoftware%2Fjunos-security%2F']],
			[['tseries'],['&qptechpubsnew=url%3A%2Ftechpubs%2Fen_US%2Frelease-independent%2Fjunos%2Finformation-products%2Ftopic-collections%2Fhardware%2Ft-series%2F%2Curl%3A%2Ftechpubs%2Fhardware%2Fcommon%2F%2Csubject%3Atseries']],
			[['junos'],['&qptechpubsnew=url%3A%2Ftechpubs%2Fsoftware%2Fjunos%2Fjunos104%2F%2Curl%3A%2Ftechpubs%2Fen_US%2Fjunos10.4%2F%2Curl%3A%2Ftechpubs%2Fsoftware%2Fnog%2Fnog-hardware%2F']],
			[['src'],['&qptechpubsnew=subject%3Asrcsoftware%2Curl%3A%2Ftechpubs%2Fen_US%2Fsrc4.0%2F%2Curl%3A%2Ftechpubs%2Fsoftware%2Fmanagement%2Fsrc%2Fsrc40x%2F']],
			[['wx'],['&qptechpubsnew=url%3A%2Ftechpubs%2Fhardware%2Fwx%2F']]];


function searchKeyPress(e)
{
		// look for window.event in case event isn't passed in
		if (window.event) { e = window.event; }
		if (e.keyCode == 13)
		{
			$("#btnTechpubsSearch").click();
		}
}

function doTechDocSearch(products){

	var searchString = $("#docsearch").val();
	var url;
	searchString = searchString.replace(/ /g,'+');
	searchString = escape(searchString);

	if(products != null){
		var qparam = getUrlParam(products);
		url = 'http://www.juniper.net/search/us/en/search.do?cmd=search&qt=' + searchString + '&col=techpubs&selectedprod=selectedprod' + qparam;
	}else{
		url = 'http://www.juniper.net/search/us/en/search.do?cmd=search&qt=' + searchString + '&col=techpubs&selectedprod=allprod';
	}
	window.location = url;
}

function getUrlParam(products){
	var qparam = "";
	var productArr = products.split(',');

	for(var j=0; j<productArr.length; j++){
		for(var i=0; i<productIndex.length; i++){
			if(productIndex[i][0] == productArr[j]){
				qparam += productIndex[i][1];
			}
		}
	}
	return qparam;
}

function showAllFew(id,all){
	if(all){
		$("#"+id+"-a").css("height","auto");
		$("#"+id+"-b").css("height","auto");
		$("#"+id+"-c").css("height","auto");
		$("#"+id+"-seeall").hide();
		$("#"+id+"-seefew").show();
	}else{
		$("#"+id+"-a").css("height","210px");
		$("#"+id+"-b").css("height","180px");
		$("#"+id+"-c").css("height","145px");
		$("#"+id+"-seeall").show();
		$("#"+id+"-seefew").hide();
	}
}

var topicPlatforms = metaData("platform");
	
function metaData(type) {
  var metas = document.getElementsByTagName('META');
  var i;
  for (i = 0; i < metas.length; i++)
    if (metas[i].getAttribute('NAME') == type)
      break;
  if(metas[i] != null){
  	return metas[i].getAttribute('CONTENT');
  }else{
	return null;
  }
}

function loadRightNavTop(){
	addSearchBox();
	if(topicPlatforms != null){
		addPromo();
		if(metaData("supportedlist") == "true"){
			addSupportedPlatforms();		
		}
	}
}

function loadRightNavBottom(){
	if(topicPlatforms != null){
		addJNETs();
		addRelatedLinks();
	}
}

function addSearchBox(){
	var searchBox = null;
	var platformName = "";
	var searchFilter = "";
	var softwareFilter = "";
	
	if(topicPlatforms != null){
		if(topicPlatforms.indexOf(",") != -1){
			var platformList = topicPlatforms.split(",");
			for(i in platformList){
				if(getSearchFilter(platformList[i]) != null){
					if(searchFilter == ""){
						searchFilter = getSearchFilter(platformList[i]);				
					}else{
						if(searchFilter.indexOf(getSearchFilter(platformList[i])) == -1)
						{
							searchFilter = searchFilter + "," + getSearchFilter(platformList[i]);
						}
					}
					platformName = "Supported Platforms";
				}
			}
		}else{
			if(getSearchFilter(topicPlatforms) != null){
				searchFilter = getSearchFilter(topicPlatforms);
				platformName = getPlatformGroupName(topicPlatforms);
			}
		}

		if(metaData("software") != null){
			softwareFilter = getSoftwareFilter(metaData("software"));
			if(softwareFilter != null){
				if(searchFilter != ""){
					searchFilter = searchFilter + "," + softwareFilter;
				}else{
					searchFilter = softwareFilter;
				}
			}
		}

		if(platformName == ""){
			platformName = "Documentation";
		}

		if(searchFilter != ""){
			searchBox = '<div class="rsearchbox"><h2 class="searchhead">' + platformName +' Search</h2><input maxlength="100" type="text" id="docsearch" onkeypress="searchKeyPress(event);"/><input type="image" id="btnTechpubsSearch" onclick="doTechDocSearch(\'' + searchFilter + '\')" src="../../../../../../../../../uat.juniper.net/shared/img/global/btn-search-blue.gif" style="margin:5px;"/><div class="advbuttons"><a href="http://uat.juniper.net/search/us/en/search.do?adv=new&col=techpubs&selectedprod=allprod" style="color:#ffffff">Advanced Search</a> | <img src="../../../../../../../../../uat.juniper.net/shared/img/global/new_window_bg_icon.gif" alt=""/> <a href="http://uat.juniper.net/us/en/help-search/" target="_blank" style="color:#ffffff">Search Tips</a></div></div>';
		}else{
			searchBox = '<div class="rsearchbox"><h2 class="searchhead">Documentation Search</h2><input maxlength="100" type="text" id="docsearch" onkeypress="searchKeyPress(event);"/><input type="image" id="btnTechpubsSearch" onclick="doTechDocSearch()" src="../../../../../../../../../uat.juniper.net/shared/img/global/btn-search-blue.gif" style="margin:5px;"/><div class="advbuttons"><a href="http://uat.juniper.net/search/us/en/search.do?adv=new&col=techpubs&selectedprod=allprod" style="color:#ffffff">Advanced Search</a> | <img src="../../../../../../../../../uat.juniper.net/shared/img/global/new_window_bg_icon.gif" alt=""/> <a href="http://uat.juniper.net/us/en/help-search/" target="_blank" style="color:#ffffff">Search Tips</a></div></div>';
		}
	}else{
		searchBox = '<div class="rsearchbox"><h2 class="searchhead">Documentation Search</h2><input maxlength="100" type="text" id="docsearch" onkeypress="searchKeyPress(event);"/><input type="image" id="btnTechpubsSearch" onclick="doTechDocSearch()" src="../../../../../../../../../uat.juniper.net/shared/img/global/btn-search-blue.gif" style="margin:5px;"/><div class="advbuttons"><a href="http://uat.juniper.net/search/us/en/search.do?adv=new&col=techpubs&selectedprod=allprod" style="color:#ffffff">Advanced Search</a> | <img src="../../../../../../../../../uat.juniper.net/shared/img/global/new_window_bg_icon.gif" alt=""/> <a href="http://uat.juniper.net/us/en/help-search/" target="_blank" style="color:#ffffff">Search Tips</a></div></div>';
	}
	
	document.write(searchBox);
}

function addPromo(){
	var promoId = metaData("promoid");
	var mOrTHref = null;
	var promoInclude = "";
	var hwPlatform;
	
	if(promoId != null){
		if(topicPlatforms.indexOf(",") != -1){
			hwPlatform = topicPlatforms.substring(0,topicPlatforms.indexOf(","));
		}else{
			hwPlatform = topicPlatforms;
		}

		if(promoId.indexOf(",") != -1){
			var promoList = promoId.split(",");
			for(pid in promoList){
                                mOrTHref = getPromoHref(promoList[pid], hwPlatform);
				if(mOrTHref != null){
					promoInclude = promoInclude + '<!--#include virtual="'+ mOrTHref + '"-->';
				}
			}
		}else{
			mOrTHref = getPromoHref(promoId, hwPlatform);
			if(mOrTHref != null){
				promoInclude = '<!--#include virtual="'+ mOrTHref + '"-->';
			}
		}
		
		if(promoInclude != ""){
			document.write(promoInclude);
		}
	}
}

function addSupportedPlatforms(){
	var sPlatform = "";
	var i, j, spid;
	var spList = new Array();
	
	if(topicPlatforms.indexOf(",") != -1){
		var platformList = topicPlatforms.split(",");
		spList = getPlatformNameArr(platformList);
	
		if(spList.length != 0){
			spList.sort(sortByName);
			var groupArr = new Array();
			for(i in spList){
				groupArr[i] = spList[i].group;
			}
			groupArr = unique(groupArr);
			
			for(j in groupArr){
				var spLink="";
				for(spid in spList){
					if(spList[spid].group == groupArr[j]){
						if(spLink == ""){
							spLink = '<a href="' + spList[spid].href + '">' + spList[spid].name + '</a>';
						}else{
							spLink = spLink + ", " + '<a href="' + spList[spid].href + '">' + spList[spid].name + '</a>';
						}
					}
				}
				if(sPlatform == ""){
					sPlatform = "<li>" + spLink + "</li>";
				}else{
					sPlatform = sPlatform + "<li>" + spLink + "</li>";				
				}
			}
		}
		
	}else{
		spList = getPlatformName(topicPlatforms);
		if(spList.length != 0){
			sPlatform = '<li><a href="' + spList[0].href + '">' + spList[0].name + '</a></li>';
		}
	}

	if(sPlatform != ""){
		var sPlatformDiv = '<div class="gradientContainer" style="margin-top: 10px;"><div class="moduleRightTop"> </div><div class="scmDefault clear"><h2>Supported Platforms</h2><ul>' + sPlatform + '</ul></div><div class="moduleRightBottom"> </div></div>';
		document.write(sPlatformDiv);
	}
}

function sortByName(aName, bName) {
    var x = aName.name.toLowerCase();
    var y = bName.name.toLowerCase();
    return ((x < y) ? -1 : ((x > y) ? 1 : 0));
}

function unique(arrayName)
{
	var newArray=new Array();
	label:for(var i=0; i<arrayName.length;i++ )
	{  
	    for(var j=0; j<newArray.length;j++ )
	    {
		if(newArray[j]==arrayName[i]) 
		    continue label;
	    }
	    newArray[newArray.length] = arrayName[i];
	}
	return newArray;
}


function addJNETs(){
	var jnetForumName = null;
	var hwPlatform;

	if(topicPlatforms.indexOf(",") != -1){
		hwPlatform = topicPlatforms.substring(0,topicPlatforms.indexOf(","));
	}else{
		hwPlatform = topicPlatforms;
	}

	jnetForumName = getJNETForumName(hwPlatform);
	
	if(jnetForumName != null){
		var jNetsStr1 = '<div class="utBoxWrapper"><div class="utBox" id="communityposts-a"><div class="utBoxHd">Recent Community Posts</div><div class="utBoxContWrapper left" id="communityposts-b"><div class="utBoxCont" id="communityposts-c"><script id="ACTIVECAST-LT" type="text/javascript" defer="defer">'
		jNetsStr2 = "";
		if(jnetForumName.indexOf(",") != -1){
			jNetList = jnetForumName.split(",");
			for(i in jNetList){
				jNetsStr2 = jNetsStr2 + 'LITHIUM.ActiveCast.getLatestThreads("' + jNetList[i] + '", {maxNumberOfMessages: 5,lookupThreadBy: "BOARD"});'
			}
		}else{
			jNetsStr2 = 'LITHIUM.ActiveCast.getLatestThreads("' + jnetForumName + '", {maxNumberOfMessages: 10,lookupThreadBy: "BOARD"});'
		}

		var jNetsStr3 = '</script></div><div style="text-align: center;"><a id="communityposts-seeall" href="javascript:showAllFew(\'communityposts\',true)" class="afbutton" style="display: block;">Show All <img src="../../../../../../../images/arrow-down.gif" alt=""/></a><a id="communityposts-seefew" href="javascript:showAllFew(\'communityposts\',false)" class="afbutton" style="display: none;">Show Fewer <img src="../../../../../../../images/arrow-up.gif" alt=""/></a></div></div><div class="utBoxInBtm"><div class="utBoxInBtmR"> </div></div></div><div class="utBoxBtm"><div class="utBoxBtmR"> </div></div></div>';
		jNets = jNetsStr1 + jNetsStr2 + jNetsStr3;
		document.write(jNets);
	}
}

function addRelatedLinks(){
	var relateLinks = null;
	var hwPlatform;
	
	if(topicPlatforms.indexOf(",") != -1){
		hwPlatform = topicPlatforms.substring(0,topicPlatforms.indexOf(","));
	}else{
		hwPlatform = topicPlatforms;
	}
	
	relateLinks = getRelatedLinks(hwPlatform);
	
	if(relateLinks != null){
		document.write(relateLinks);
	}
}

function getPlatformGroupName(hwPlatform){
	var i, j;
	
	for (i in platforms.platformGroup)
	{
		if(platforms.platformGroup[i].hardwarePlatform == hwPlatform){
			return platforms.platformGroup[i].name;
		}else{
			for (j in platforms.platformGroup[i].platform)
			{
				if(platforms.platformGroup[i].platform[j].hardwarePlatform == hwPlatform){
					return platforms.platformGroup[i].name;
				}
			}
		}
	}
}

function getPlatformName(hwPlatform){
	var i, j;
	var platformLink = new Array();	
	var li = 0;
	
	for (i in platforms.platformGroup)
	{
		if(platforms.platformGroup[i].hardwarePlatform == hwPlatform){
			platformLink[li] = new Array(3);
			platformLink[li].href = platforms.platformGroup[i].href;
			platformLink[li].name = platforms.platformGroup[i].name;
			platformLink[li].group = platforms.platformGroup[i].name;
			li++;
		}else{
			for (j in platforms.platformGroup[i].platform)
			{
				if(platforms.platformGroup[i].platform[j].hardwarePlatform == hwPlatform){
					platformLink[li] = new Array(3);
					platformLink[li].href = platforms.platformGroup[i].platform[j].href;
					platformLink[li].name = platforms.platformGroup[i].platform[j].name;
					platformLink[li].group = platforms.platformGroup[i].name;
					li++;
				}
			}
		}
	}
	return platformLink;
}

function getPlatformNameArr(platformList){
	var pli, i, j;
	var platformsLink = new Array();
	var pIndex = 0;

	for(pli in platformList){
		i = 0;
		j = 0;
		for (i in platforms.platformGroup)
		{
			if(platforms.platformGroup[i].hardwarePlatform == platformList[pli]){
				platformsLink[pIndex] = new Array(3);
				platformsLink[pIndex].href = platforms.platformGroup[i].href;
				platformsLink[pIndex].name = platforms.platformGroup[i].name;
				platformsLink[pIndex].group = platforms.platformGroup[i].name;
				pIndex++;
			}else{
				for (j in platforms.platformGroup[i].platform)
				{
					if(platforms.platformGroup[i].platform[j].hardwarePlatform == platformList[pli]){
						platformsLink[pIndex] = new Array(3);
						platformsLink[pIndex].href = platforms.platformGroup[i].platform[j].href;
						platformsLink[pIndex].name = platforms.platformGroup[i].platform[j].name;
						platformsLink[pIndex].group = platforms.platformGroup[i].name;
						pIndex++;
					}
				}
			}
		}
	}
	return platformsLink;
}

function getSearchFilter(hwPlatform){
	var i, j;
	
	for (i in platforms.platformGroup)
	{
		if(platforms.platformGroup[i].hardwarePlatform == hwPlatform){
			return platforms.platformGroup[i].searchFilter;
		}else{
			for (j in platforms.platformGroup[i].platform)
			{
				if(platforms.platformGroup[i].platform[j].hardwarePlatform == hwPlatform){
					return platforms.platformGroup[i].searchFilter;
				}
			}
		}
	}
	return null;
}

function getSoftwareFilter(swMetadata){
	var i, j;
	var software;
	
	if(swMetadata.indexOf(",") != -1){
		software = swMetadata.substring(0,topicPlatforms.indexOf(","));
	}else{
		software = swMetadata;
	}
	
	for (i in platforms.platformGroup)
	{
		if(platforms.platformGroup[i].softwareProduct == software){
			return platforms.platformGroup[i].softwareFilter;
		}else{
			for (j in platforms.platformGroup[i].platform)
			{
				if(platforms.platformGroup[i].platform[j].softwareProduct == software){
					return platforms.platformGroup[i].softwareFilter;
				}
			}
		}
	}
	return null;
}

function getPromoHref(promoVar, hwPlatform){
	var i, j;
	var href = null;
	
	for (i in platforms.platformGroup)
	{
		if(platforms.platformGroup[i].hardwarePlatform == hwPlatform){
			if(promoVar == "marketing-href"){
				href = platforms.platformGroup[i].marketingPromoHref;
			}else{
				href = platforms.platformGroup[i].techpubsSurveyPromoHref;
			}
		}else{
			for (j in platforms.platformGroup[i].platform)
			{
				if(platforms.platformGroup[i].platform[j].hardwarePlatform == hwPlatform){
					if(promoVar == "marketing-href"){
						href = platforms.platformGroup[i].marketingPromoHref;
					}else{
						href = platforms.platformGroup[i].techpubsSurveyPromoHref;
					}
				}
			}
		}
	}
	
	return href;
}

function getJNETForumName(hwPlatform){
	var i,j;
	var jFName;
	
	for (i in platforms.platformGroup)
	{
		if(platforms.platformGroup[i].hardwarePlatform == hwPlatform){
			jFName = platforms.platformGroup[i].jnetForumName;
		}else{
			for (j in platforms.platformGroup[i].platform)
			{
				if(platforms.platformGroup[i].platform[j].hardwarePlatform == hwPlatform){
					jFName = platforms.platformGroup[i].jnetForumName;
				}
			}
		}
	}
	return jFName;
}

function getRelatedLinks(hwPlatform){
	var i,j;
	var rLinks;

	for (i in platforms.platformGroup)
	{
		if(platforms.platformGroup[i].hardwarePlatform == hwPlatform){
			rLinks = platforms.platformGroup[i].relatedLinks;
		}else{
			for (j in platforms.platformGroup[i].platform)
			{
				if(platforms.platformGroup[i].platform[j].hardwarePlatform == hwPlatform){
					rLinks = platforms.platformGroup[i].relatedLinks;
				}
			}
		}
	}
	return rLinks;
}